<?php

try {
    // get image
    $filename = $_GET['photo'];

    // create IMagick object
    $im = new IMagick($filename);

    if ($im->getImageFormat() == 'JPEG')
       $im->setImageFormat("png");

    // create thumbnail
    $im->thumbnailImage(300,null);

    // round corners
    $im->roundCorners(5,5);

    // clone object
    $shadow = $im->clone();

    // add shadow
    $shadow->setImageBackgroundColor(new ImagickPixel('black'));
    $shadow->shadowImage(80,3,5,5);

    // compose image
    $shadow->compositeImage($im, Imagick::COMPOSITE_OVER,0,0);

    // print image
    header( "Content-Type: image/png" );
    echo $shadow;

    // clean up
    $shadow->destroy();
    $im->destroy();
} catch(ImagickException $e) {
   echo "Problems with image file ", $e->getMessage, "\n";
}
?>
